/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.actionControllers;

import com.aptana.configurations.processor.ConfigurationProcessorsRegistry;
import com.aptana.configurations.processor.IConfigurationProcessor;
import com.aptana.configurations.processor.IConfigurationProcessorListener;
import com.aptana.core.logging.IdeLog;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.BrowserNotifier;
import com.aptana.portal.ui.dispatch.IActionController;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import com.aptana.portal.ui.dispatch.actionControllers.Messages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractActionController
implements IActionController,
IConfigurationProcessorListener {
    private Map<String, Method> actions;
    private String configurationProcessorID;
    private IConfigurationProcessor processor;

    @Override
    public String[] getActions() {
        Set<String> actionNames = this.getActionsMap().keySet();
        return actionNames.toArray(new String[actionNames.size()]);
    }

    @Override
    public boolean hasAction(String action) {
        return this.getActionsMap().containsKey(action);
    }

    @Override
    public Object invokeAction(String action, Object args) {
        Method method = this.getActionsMap().get(action);
        if (method != null) {
            try {
                IConfigurationProcessor processor;
                Object[] params = null;
                params = args == null ? new Object[]{} : new Object[]{args};
                String processorId = this.getConfigurationProcessorId();
                if (processorId != null && (processor = this.getProcessor()) == null) {
                    String message = MessageFormat.format("The configuration process for {0} was null", this.getClass().getName());
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
                    return this.createInternalErrorNotification();
                }
                Object result = method.invoke((Object)this, params);
                if (result == null) {
                    return IBrowserNotificationConstants.JSON_OK;
                }
                return result;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)MessageFormat.format("Error invoking a portal action. Action = ''{0}'', Args = ''{1}''", action, args instanceof Object[] ? Arrays.toString((Object[])args) : args), (Throwable)e);
                String message = e.getMessage();
                if (e instanceof InvocationTargetException) {
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    message = targetException.getMessage();
                }
                return BrowserNotifier.toJSONErrorNotification("error", message);
            }
        }
        return BrowserNotifier.toJSONErrorNotification("Unknown Action", String.valueOf(Messages.AbstractActionController_invocationError) + action);
    }

    @Override
    public String getConfigurationProcessorId() {
        return this.configurationProcessorID;
    }

    @Override
    public void setConfigurationProcessorId(String id) {
        this.configurationProcessorID = id;
    }

    @ControllerAction
    public Object listActions() {
        Set<String> keySet = this.getActionsMap().keySet();
        return JSON.toString((Object[])keySet.toArray(new String[keySet.size()]));
    }

    protected Map<String, Method> getActionsMap() {
        if (this.actions == null) {
            this.loadActions();
        }
        return this.actions;
    }

    protected synchronized void loadActions() {
        Method[] methods;
        this.actions = new HashMap<String, Method>();
        Method[] methodArray = methods = this.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(ControllerAction.class)) {
                ControllerAction annotation = method.getAnnotation(ControllerAction.class);
                String annotationName = annotation.name();
                if (annotationName == null || "".equals(annotationName)) {
                    this.actions.put(method.getName(), method);
                } else {
                    this.actions.put(annotationName, method);
                }
            }
            ++n2;
        }
    }

    protected Object createInternalErrorNotification() {
        return BrowserNotifier.toJSONErrorNotification("error", Messages.ActionController_internalError);
    }

    protected IConfigurationProcessor getProcessor(boolean createNewInstance) {
        if (createNewInstance) {
            return ConfigurationProcessorsRegistry.getInstance().getConfigurationProcessor(this.getConfigurationProcessorId());
        }
        if (this.processor == null) {
            this.processor = ConfigurationProcessorsRegistry.getInstance().getConfigurationProcessor(this.getConfigurationProcessorId());
        }
        return this.processor;
    }

    protected IConfigurationProcessor getProcessor() {
        return this.getProcessor(false);
    }

    protected String getCallback(Object attributes) {
        Object[] arr;
        if (attributes instanceof Object[] && (arr = (Object[])attributes).length > 1 && arr[1] != null) {
            return String.valueOf(arr[1]);
        }
        return null;
    }
}

